#include "GUIAgent.h"
#include "GUIFilter.h"
#include "../DataTypes/DataGUIAgent.h"

namespace Communication
{

GUIAgent::GUIAgent()
{
	this->agentkey = "GUI";
	this->filter = FilterFactory::GetInstance()->GetGUIFilter();
	this->syncflag = false;
}

GUIAgent::GUIAgent(int port, string ip, bool syncmode, double broadcastint, string key)
{
	this->port = port;
	this->ip = ip;
	this->syncmode = syncmode;
	this->agentkey = key;
	this->filter = FilterFactory::GetInstance()->GetGUIFilter();
	this->broadcastinterval = broadcastint;
	this->syncflag = false;
}

GUIAgent::~GUIAgent()
{
}

int GUIAgent::GetPort()
{
	return this->port;
}

string GUIAgent::GetIP()
{
	return this->ip;
}

bool GUIAgent::GetSyncMode()
{
	return this->syncmode;
}

bool GUIAgent::GetSyncFlag()
{
	return this->syncflag;
}

int GUIAgent::GetIterationSync()
{
	return this->iterationsync;
}

string GUIAgent::GetKey()
{
	return this->agentkey;
}

void GUIAgent::SetPort(int port)
{
	this->port = port;
}
void GUIAgent::SetIP(string ip)
{
	this->ip = ip;
}
void GUIAgent::SetKey(string key)
{
	this->agentkey = key;
}

void GUIAgent::SetSyncMode(bool syncmode)
{
	this->syncmode = syncmode;
}

string GUIAgent::FilterData(string data)
{
	return this->filter->FilterData(data);
}

DataAgent* GUIAgent::GetDataAgent()
{
	return new DataGUIAgent(port, ip, broadcastinterval, syncmode,agentkey);
}

double GUIAgent::GetTimeStamp()
{
	return timestamp;
}

void GUIAgent::SetTimeStamp(double value)
{
	this->timestamp = value;
}

double GUIAgent::GetBroadcastInterval()
{
	return broadcastinterval;
}

void GUIAgent::SetBroadcastInterval(double value)
{
	this->broadcastinterval = value;
}

void GUIAgent::SetSyncFlag(bool value)
{
	this->syncflag = value;
}

void GUIAgent::SetIterationSync(int value)
{
	this->iterationsync = value;
}

}
